using UnityEngine;
using System.Threading;
using System;
using System.Runtime.InteropServices;

namespace hive.adkit.daro
{
	public enum PositionType : int {
		TOP = 0,
		BOTTOM = 1
	}

	public class AdKitBase : MonoBehaviour
	{
		public const string ADKIT_UNITY_PLUGIN_VERSION = "1.5.3";

#if UNITY_ANDROID && !UNITY_EDITOR

		private static string adKitPluginClass = "com.hive.adkit.daro.plugin.AdKitUnityPlugin";
		
		public static void Initialize() {
			using (var unityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer"))
			using (var currentActivity = unityPlayer.GetStatic<AndroidJavaObject>("currentActivity"))
			using (var adKitPlugin = new AndroidJavaClass(adKitPluginClass)) {
				AdKitLogger.d("::Hive AdKit Initialize() call" );
				adKitPlugin.CallStatic("initialize", currentActivity);
			}
		}

		public static void ShowConsentUI(string noticeId) {
			using (var adKitPlugin = new AndroidJavaClass(adKitPluginClass)) {
				AdKitLogger.d("::Hive AdKit ShowConsentUI() call" );
				adKitPlugin.CallStatic("showConsentUI", noticeId);
			}
		}

		public static void SetUserId(string userId) {
			using (var adKitPlugin = new AndroidJavaClass(adKitPluginClass)) {
				AdKitLogger.d("::Hive AdKit SetUserId() call" );
				adKitPlugin.CallStatic("setUserId", userId);
			}
		}

		public static void SetAdditionalInfo(string additionalInfo) {
			using (var adKitPlugin = new AndroidJavaClass(adKitPluginClass)) {
				AdKitLogger.d("::Hive AdKit SetAdditionalInfo() call" );
				adKitPlugin.CallStatic("setAdditionalInfo", additionalInfo);
			}
		}

		public static void SetLogEnable(bool isOn) {
			using (var adKitPlugin = new AndroidJavaClass(adKitPluginClass)) {
				AdKitLogger.d("::Hive AdKit SetLogEnable() call" );
				adKitPlugin.CallStatic("setLogEnable", isOn);
			}
		}

#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void AdKit_Initialize(string callbackObject, string callbackFunction);

		[DllImport("__Internal")]
		private static extern void AdKit_ShowConsentUI(string noticeId, string callbackObject, string callbackFunction);

		[DllImport("__Internal")]
		private static extern void AdKit_SetUserId(string userId);

		[DllImport("__Internal")]
		private static extern void AdKit_SetAdditionalInfo(string additionalInfo);

		[DllImport("__Internal")]
		private static extern void AdKit_SetLogEnable(bool isOn);


		public static void Initialize() {
			AdKitLogger.d("::Hive AdKit Initialize() call" );
			AdKit_Initialize("AdKitCallbackManager", "onSdkInitialize");
		}

		public static void ShowConsentUI(string noticeId) {
			AdKitLogger.d("::Hive AdKit ShowConsentUI() call" );
			AdKit_ShowConsentUI(noticeId, "AdKitCallbackManager", "onShowConsentUI");
		}

		public static void SetUserId(string userId) {
			AdKitLogger.d("::Hive AdKit SetUserId() call" );
			AdKit_SetUserId(userId);
		}

		public static void SetAdditionalInfo(string additionalInfo) {
			AdKitLogger.d("::Hive AdKit SetAdditionalInfo() call" );
			AdKit_SetAdditionalInfo(additionalInfo);
		}

		public static void SetLogEnable(bool isOn) {
			AdKitLogger.d("::Hive AdKit SetLogEnable() call" );
			AdKit_SetLogEnable(isOn);
		}
#else

		public static void Initialize() {
			
		}
		
		public static void ShowConsentUI(string noticeId) {
			
		}

		public static void SetUserId(string userId) {
			
		}

		public static void SetAdditionalInfo(string additionalInfo) {
			
		}

		public static void SetLogEnable(bool isOn)
		{

		}	
#endif
	}
}